//=============================================================================
// WeaponKarkianBump.
//=============================================================================
class WeaponShockAOE extends WeaponNPCMelee;

function Fire(float A)
{
 ActivateAOE();
 
 Super.Fire(a);
}

//Protip: you die from suicide attacks

function ActivateAOE()
{
 HurtRadius(25, 128, 'Shocked', 1, Owner.Location);
 SpawnExplosionEffects(Owner.Location);
 PlaySound(sound'EMPGrenadeExplode');
}

function SpawnExplosionEffects(Vector HitLocation)
{
	local ShockRing ring;
	local SphereEffect sphere;
	local ExplosionLight light;
	local AnimatedSprite expeffect;
	local Vector hitNormal;
	local float BlastRadius;
	local ShockSplashLarge S;
	
	BlastRadius = 256;
	
	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
   if (light != None)
      light.RemoteRole = ROLE_None;

      light.size = 4;

	/*expeffect = Spawn(class'ExplosionMedium',,, HitLocation);
	light.size = 4;

   if (expeffect != None)
      expeffect.RemoteRole = ROLE_None;*/

	S = Spawn(class'ShockSplashLarge',,, HitLocation);

	// draw a pretty shock ring
   	// For nano defense we are doing something else.

      ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
      /*ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }*/
}

defaultproperties
{
     ShotTime=0.900000
     HitDamage=50
     maxRange=140
     AccurateRange=140
     BaseAccuracy=0.000000
     AITimeLimit=10.000000
     AIFireDelay=8.000000
}
